' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa Customer reprezentuje uytkownika, ktry zoy zamwienie w sklepie internetowym.
''' </summary>
Public Class Customer

#Region "Zmienne prywatne"

  Private _customerId As Guid
  Private _firstName As String = String.Empty
  Private _lastName As String = String.Empty
  Private _street As String = String.Empty
  Private _zipCode As String = String.Empty
  Private _city As String = String.Empty
  Private _country As String = String.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Tworzy nowy obiekt uytkownika i wypenia jego wszystkie wymagane pola.
  ''' </summary>
  ''' <param name="customerId">Unikalny identyfikator uytkownika.</param>
  ''' <param name="firstName">Imi uytkownika.</param>
  ''' <param name="lastName">Nazwisko uytkownika.</param>
  ''' <param name="street">Adres uytkownika.</param>
  ''' <param name="zipCode">Kod pocztowy uytkownika.</param>
  ''' <param name="city">Miasto uytkownika.</param>
  ''' <param name="country">Kraj uytkownika.</param>
  ''' <remarks>Uyj tego konstruktora aby cakowicie wypeni obiektu uytkownika. Wszystkie waciwoci klasy Customer s w koszyku, wic to jest jedyny sposb na ich ustawienie.</remarks>
  Public Sub New(ByVal customerId As Guid, ByVal firstName As String, ByVal lastName As String, ByVal street As String, ByVal zipCode As String, ByVal city As String, ByVal country As String)
    _customerId = customerId
    _firstName = firstName
    _lastName = lastName
    _street = street
    _zipCode = zipCode
    _city = city
    _country = country
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera unikalny identyfikator uytkownika, pochodzcy z MembershipUser.ProviderUserKey.
  ''' </summary>
  Public ReadOnly Property CustomerId() As Guid
    Get
      Return _customerId
    End Get
  End Property

  ''' <summary>
  ''' Pobiera imi uytkownika.
  ''' </summary>
  Public ReadOnly Property FirstName() As String
    Get
      Return _firstName
    End Get
  End Property

  ''' <summary>
  ''' Pobiera nazwisko uytkownika.
  ''' </summary>
  Public ReadOnly Property LastName() As String
    Get
      Return _lastName
    End Get
  End Property

  ''' <summary>
  ''' Pobiera adres uytkownika.
  ''' </summary>
  Public ReadOnly Property Street() As String
    Get
      Return _street
    End Get
  End Property

  ''' <summary>
  ''' Pobiera kod pocztowy uytkownika.
  ''' </summary>
  Public ReadOnly Property ZipCode() As String
    Get
      Return _zipCode
    End Get
  End Property

  ''' <summary>
  ''' Pobiera miasto uytkownika.
  ''' </summary>
  Public ReadOnly Property City() As String
    Get
      Return _firstName
    End Get
  End Property

  ''' <summary>
  ''' Pobiera kraj uytkownika.
  ''' </summary>
  Public ReadOnly Property Country() As String
    Get
      Return _country
    End Get
  End Property

#End Region

End Class
